# Toko Baju Junata - API Documentation

API Backend untuk aplikasi Toko Baju Junata - Fashion E-Commerce Mobile Application

## 🚀 Quick Start

### Prerequisites
- XAMPP/WAMP/MAMP (PHP 7.4+ dan MySQL 5.7+)
- Apache dengan mod_rewrite enabled
- Ionic/Angular frontend

### Installation

1. **Setup Database**
   ```bash
   # Import database menggunakan phpMyAdmin atau MySQL CLI
   mysql -u root -p < setup_database.sql
   ```

2. **Configure Database Connection**
   
   Edit `config.php` jika credentials berbeda:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'junata_db');
   define('DB_USER', 'root');
   define('DB_PASS', '');
   ```

3. **Start Server**
   
   Pastikan Apache dan MySQL running di XAMPP

4. **Test API**
   
   Akses: `http://localhost/JunaShop/src/api/products.php?action=getAll`

---

## 📊 Database Schema

### Tables

- **users** - Data pembeli/customer
- **products** - Katalog produk fashion
- **carts** - Keranjang belanja
- **orders** - Data pesanan
- **order_items** - Detail item pesanan
- **store_info** - Informasi toko

### Views

- **v_cart_details** - Cart dengan detail produk
- **v_order_details** - Order dengan detail items
- **v_product_catalog** - Katalog produk dengan status stok

### Stored Procedures

- **sp_create_order** - Membuat pesanan dari cart
- **sp_get_user_orders** - Ambil semua pesanan user
- **sp_get_order_detail** - Detail pesanan
- **sp_update_stock** - Update stok produk

---

## 🔑 API Endpoints

### Base URL
```
http://localhost/JunaShop/src/api/
```

---

## 👤 Authentication API (`auth.php`)

### Register
**POST** `/auth.php?action=register`

**Request Body:**
```json
{
  "nama": "John Doe",
  "email": "john@example.com",
  "password": "password123",
  "no_telp": "081234567890",
  "alamat": "Jl. Contoh No. 123"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Registration successful",
  "data": {
    "id": 1,
    "nama": "John Doe",
    "email": "john@example.com",
    "no_telp": "081234567890",
    "alamat": "Jl. Contoh No. 123",
    "foto_profil": "default-avatar.png",
    "created_at": "2026-01-19 10:00:00"
  }
}
```

### Login
**POST** `/auth.php?action=login`

**Request Body:**
```json
{
  "email": "john@example.com",
  "password": "password123"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Login successful",
  "data": {
    "id": 1,
    "nama": "John Doe",
    "email": "john@example.com",
    "no_telp": "081234567890",
    "alamat": "Jl. Contoh No. 123",
    "foto_profil": "default-avatar.png"
  }
}
```

---

## 👕 Products API (`products.php`)

### Get All Products
**GET** `/products.php?action=getAll`

**Response:**
```json
{
  "success": true,
  "message": "Products retrieved successfully",
  "data": [
    {
      "id": 1,
      "nama": "Kemeja Lengan Panjang Formal",
      "deskripsi": "Kemeja formal slim fit...",
      "harga": 149000,
      "stok": 45,
      "kategori": "Pakaian Pria",
      "gambar": "kemeja-formal.jpg",
      "status_stok": "Tersedia"
    }
  ]
}
```

### Search Products
**GET** `/products.php?action=search&keyword=kemeja`

### Filter by Category
**GET** `/products.php?action=filter&kategori=Pakaian%20Pria`

### Get Product Detail
**GET** `/products.php?action=detail&id=1`

### Get Categories
**GET** `/products.php?action=categories`

**Response:**
```json
{
  "success": true,
  "message": "Categories retrieved successfully",
  "data": [
    {
      "kategori": "Pakaian Pria",
      "total_products": 5
    },
    {
      "kategori": "Pakaian Wanita",
      "total_products": 5
    }
  ]
}
```

---

## 🛒 Cart API (`cart.php`)

### Add to Cart
**POST** `/cart.php?action=add`

**Request Body:**
```json
{
  "user_id": 1,
  "product_id": 1,
  "quantity": 2
}
```

**Response:**
```json
{
  "success": true,
  "message": "Added to cart successfully",
  "data": {
    "cart_id": 1
  }
}
```

### Get Cart Items
**GET** `/cart.php?action=get&user_id=1`

**Response:**
```json
{
  "success": true,
  "message": "Cart items retrieved successfully",
  "data": {
    "items": [
      {
        "id": 1,
        "user_id": 1,
        "product_id": 1,
        "quantity": 2,
        "product_nama": "Kemeja Lengan Panjang Formal",
        "product_harga": 149000,
        "product_gambar": "kemeja-formal.jpg",
        "subtotal": 298000
      }
    ],
    "total_items": 1,
    "total_amount": 298000
  }
}
```

### Update Cart Item
**PUT** `/cart.php?action=update`

**Request Body:**
```json
{
  "cart_id": 1,
  "quantity": 3
}
```

### Remove from Cart
**DELETE** `/cart.php?action=remove&id=1`

### Clear Cart
**DELETE** `/cart.php?action=clear&user_id=1`

---

## 📦 Orders API (`orders.php`)

### Create Order
**POST** `/orders.php?action=create`

**Request Body:**
```json
{
  "user_id": 1,
  "nama_penerima": "John Doe",
  "no_telp_penerima": "081234567890",
  "alamat_pengiriman": "Jl. Pengiriman No. 123, Jakarta",
  "note": "Kirim pagi hari",
  "payment_method": "Transfer Bank BCA"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Order created successfully",
  "data": {
    "id": 1,
    "user_id": 1,
    "total_amount": 298000,
    "status": "Dikirim",
    "total_items": 1,
    "created_at": "2026-01-19 10:30:00"
  }
}
```

### Get User Orders
**GET** `/orders.php?action=getByUser&user_id=1`

**Response:**
```json
{
  "success": true,
  "message": "Orders retrieved successfully",
  "data": [
    {
      "id": 1,
      "total_amount": 298000,
      "nama_penerima": "John Doe",
      "status": "Dikirim",
      "total_items": 1,
      "created_at": "2026-01-19 10:30:00"
    }
  ]
}
```

### Get Order Detail
**GET** `/orders.php?action=detail&id=1`

**Response:**
```json
{
  "success": true,
  "message": "Order detail retrieved successfully",
  "data": {
    "order": {
      "id": 1,
      "user_id": 1,
      "total_amount": 298000,
      "nama_penerima": "John Doe",
      "no_telp_penerima": "081234567890",
      "alamat_pengiriman": "Jl. Pengiriman No. 123",
      "note": "Kirim pagi hari",
      "payment_method": "Transfer Bank BCA",
      "status": "Dikirim",
      "user_nama": "John Doe"
    },
    "items": [
      {
        "id": 1,
        "product_id": 1,
        "quantity": 2,
        "price": 149000,
        "subtotal": 298000,
        "product_nama": "Kemeja Lengan Panjang Formal",
        "product_gambar": "kemeja-formal.jpg"
      }
    ]
  }
}
```

### Update Order Status
**PUT** `/orders.php?action=updateStatus`

**Request Body:**
```json
{
  "order_id": 1,
  "status": "Selesai"
}
```

**Valid Status Values:**
- Pending
- Dikemas
- Dikirim
- Selesai
- Dibatalkan

---

## 👨‍💼 Profile API (`profile.php`)

### Get User Profile
**GET** `/profile.php?action=get&user_id=1`

**Response:**
```json
{
  "success": true,
  "message": "Profile retrieved successfully",
  "data": {
    "id": 1,
    "nama": "John Doe",
    "email": "john@example.com",
    "no_telp": "081234567890",
    "alamat": "Jl. Contoh No. 123",
    "foto_profil": "default-avatar.png",
    "total_orders": 5,
    "created_at": "2026-01-19 10:00:00"
  }
}
```

### Update Profile
**PUT** `/profile.php?action=update`

**Request Body:**
```json
{
  "user_id": 1,
  "nama": "John Updated",
  "no_telp": "081234567899",
  "alamat": "Jl. Baru No. 456",
  "foto_profil": "john-avatar.png"
}
```

### Update Password
**PUT** `/profile.php?action=updatePassword`

**Request Body:**
```json
{
  "user_id": 1,
  "current_password": "oldpassword",
  "new_password": "newpassword123"
}
```

### Get Store Information
**GET** `/profile.php?action=storeInfo`

**Response:**
```json
{
  "success": true,
  "message": "Store information retrieved successfully",
  "data": {
    "id": 1,
    "nama_toko": "Toko Baju Junata",
    "deskripsi": "Toko fashion online terpercaya...",
    "alamat": "Jl. Fashion Street No. 88, Jakarta Pusat",
    "email": "info@bajujunata.com",
    "no_telp": "021-88776655",
    "logo": "store-logo.png",
    "jam_buka": "09:00:00",
    "jam_tutup": "21:00:00"
  }
}
```

---

## ⚠️ Error Handling

All endpoints return consistent error format:

```json
{
  "success": false,
  "message": "Error description here"
}
```

### HTTP Status Codes

- `200` - Success
- `201` - Created
- `400` - Bad Request (validation error)
- `401` - Unauthorized
- `404` - Not Found
- `409` - Conflict (e.g., email already exists)
- `500` - Internal Server Error

---

## 🔒 Security Features

- ✅ Password hashing dengan bcrypt
- ✅ SQL injection protection (PDO prepared statements)
- ✅ XSS protection (input sanitization)
- ✅ CORS headers configured
- ✅ Sensitive file protection via .htaccess

---

## 📝 Sample Test Credentials

**Test User:**
- Email: `john@example.com`
- Password: `password` (hash sudah ada di database)

---

## 🛠️ Development Notes

### Database Connection Test
```php
// Test koneksi database
php -r "require 'config.php'; echo 'Database connected!';"
```

### Enable Error Logging
Errors akan dicatat di `error.log` di folder API

### CORS Issues
Jika ada CORS error, pastikan:
1. `.htaccess` file ada di folder API
2. `mod_headers` enabled di Apache
3. Restart Apache setelah perubahan

---

## 📞 Support

Untuk pertanyaan atau issue:
- Email: info@bajujunata.com
- Phone: 021-88776655

---

## 📄 License

© 2026 Toko Baju Junata. All rights reserved.
